# Generated by Django 2.2 on 2019-08-08 08:36

from django.db import migrations, models
import django.db.models.deletion
from django.db.models import Subquery, OuterRef, F


def fill_account_id(apps, schema_editor):
    TgMembership = apps.get_model('tasha', 'TgMembership')
    TelegramAccount = apps.get_model('tasha', 'TelegramAccount')

    account_qs = TelegramAccount.objects.filter(telegram_id=OuterRef('telegram_id')).values_list('id', flat=True)
    membership_qs = TgMembership.objects.all().annotate(
        telegram_id=F('username__telegram_id')
    ).annotate(_account_id=Subquery(account_qs[:1]))
    
    for membership in membership_qs:
        membership.account_id = membership._account_id
        membership.save()

class Migration(migrations.Migration):

    dependencies = [
        ('tasha', '0024_rename_tables'),
    ]

    operations = [
        migrations.AddField(
            model_name='tgmembership',
            name='account',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='tasha.TelegramAccount'),
        ),
        migrations.AlterField(
            model_name='tgmembership',
            name='username',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, null=True, to='tasha.TelegramUsername'),
        ),
        migrations.AlterUniqueTogether(
            name='tgmembership',
            unique_together={('account', 'group')},
        ),
        migrations.RunPython(fill_account_id),
    ]
