from django.utils import timezone

from tasha.constants import ACTION
from tasha.lib import cache_storage
from tasha.models import TgMembership, User


@cache_storage.memoize_decorator(1800)
def get_failed_memberships():
    now = timezone.now()
    last_email_time = now - timezone.timedelta(hours=48)
    failed_memberships = []
    fail_date = (timezone.now() - timezone.timedelta(hours=12)).date()
    fired_users = User.objects.filter(quit_at__lt=fail_date, is_active=False)
    active_memberships = TgMembership.objects.filter(
        is_active=True, account__is_bot=False, group__deactivated=False
    ).select_related('account__user')

    for membership in active_memberships.filter(account__user__in=fired_users):
        if not membership.actions.filter(added__date__gte=membership.account.user.quit_at, action=ACTION.EMAIL).exists():
            failed_memberships.append(membership.pk)

    for membership in active_memberships.filter(account__user=None):
        if not membership.actions.filter(added__gt=last_email_time, action=ACTION.EMAIL):
            failed_memberships.append(membership.pk)

    return failed_memberships
