import logging
from logging.config import dictConfig

from aiogram import Dispatcher

from tasha.core.tasha_bot import TashaBot, TashaHandlers
from tasha.lib.logging import LOGGING_CONFIG

logger = logging.getLogger(__name__)


async def _on_startup(dp: Dispatcher, handlers: TashaHandlers):
    dp.register_chat_join_request_handler(
        handlers.handle_join_request, run_task=True
    )

    dp.register_my_chat_member_handler(
        handlers.handle_member_update, run_task=True
    )

    dp.register_chat_member_handler(
        handlers.handle_member_update, run_task=True
    )


if __name__ == '__main__':
    dictConfig(LOGGING_CONFIG)
    tasha = TashaBot(
        path='channel',
        on_startup=_on_startup
    )
    tasha.start()
