import logging
from logging.config import dictConfig

from aiogram import Dispatcher
from aiogram.types import ContentType

from tasha.core.tasha_bot import TashaBot, TashaHandlers, EnsureGroupMiddleware
from tasha.lib.logging import LOGGING_CONFIG

logger = logging.getLogger(__name__)


async def _on_startup(dp: Dispatcher, handlers: TashaHandlers):
    middleware = EnsureGroupMiddleware(handlers)

    dp.setup_middleware(middleware)

    dp.register_chat_join_request_handler(
        handlers.handle_join_request, run_task=True
    )

    dp.register_my_chat_member_handler(
        handlers.handle_member_update, run_task=True
    )

    dp.register_chat_member_handler(
        handlers.handle_member_update, run_task=True
    )

    dp.register_message_handler(
        handlers.handle_enter, run_task=True, content_types=ContentType.NEW_CHAT_MEMBERS
    )
    dp.register_message_handler(
        handlers.handle_exit, run_task=True, content_types=ContentType.LEFT_CHAT_MEMBER
    )
    dp.register_message_handler(
        handlers.handle_new_chat, run_task=True, content_types=ContentType.GROUP_CHAT_CREATED
    )


if __name__ == '__main__':
    dictConfig(LOGGING_CONFIG)
    tasha = TashaBot(
        on_startup=_on_startup
    )
    tasha.start()
