from django.conf.urls import url

from tasha.views import common, uhura, slack, telegram
from tasha.admin import admin_site

urlpatterns = [
    url(r'^external/callback/$', slack.SlackCallbackView.as_view()),
    url(r'^ping/$', common.PingView.as_view()),
    url(r'^unistat/$', common.UnistatView.as_view()),
    url(r'^hanging_monitoring/$', telegram.HangingMonitoring.as_view()),
    url(r'^kick_deltas_monitoring/$', telegram.KickDeltasMonitoringView.as_view()),
    url(r'^not_scanned_monitoring/$', telegram.NotScannedMonitoringView.as_view()),
    url(r'^internal/telegram/admin/', admin_site.urls),
    url(r'^internal/telegram/addslackbotflag/$', telegram.AddSlackBotFlagView.as_view()),
    url(r'^internal/telegram/addslackbot/$', telegram.AddSlackBotView.as_view()),
    url(r'^internal/telegram/checkchat/$', telegram.KnownChatView.as_view()),
    url(r'^internal/telegram/inviteyambogram/$', telegram.InviteQBotToChat.as_view()),
    url(r'^internal/telegram/chatinfo/$', telegram.TgGroupInfoView.as_view()),
    url(r'^internal/telegram/invitetochat/$', telegram.InviteToChatView.as_view()),
    url(r'^internal/telegram/getchatparticipants/$', telegram.ChatParticipantsView.as_view()),
    url(r'^internal/telegram/get_all_chats/$', telegram.ExportChats.as_view()),
    url(r'^internal/telegram/send_message/$', telegram.SendMessageView.as_view()),
    url(r'^internal/telegram/createchat/$', telegram.CreateChatView.as_view()),
    url(
        r'^internal/telegram/group_count_monitoring/$',
        telegram.GroupsCountMonitoring.as_view(),
        name='group_count_monitoring'
    ),
    url(r'^internal/uhura/bots/$', uhura.BotsView.as_view()),
    url(r'^internal/uhura/registration/$', uhura.RegistrationView.as_view()),
    url(r'^internal/uhura/staff_monitoring/$', uhura.StaffSyncMonitoring.as_view(), name='staff_monitoring'),
]
