from django.conf import settings
from tvm2 import TVM2

is_initialized = False


def get_tvm_client():
    return TVM2(
        client_id=settings.TVM_TASHA_ID,
        secret=settings.TASHA_TVM_SECRET,
        blackbox_client=settings.INTERNAL_BLACKBOX_CLIENT,
        allowed_clients=settings.ALLOWED_TVM_APPS,
    )


def is_in_whitelist(username, telegram_id, whitelist):
    if username and (username.lower() in settings.TG_WHITELIST):
        return True

    if whitelist is None:
        return False

    whl_ids = [u.telegram_id for u in whitelist]
    whl_usernames = [u.username.lower() for u in whitelist]

    if username and (username.lower() in whl_usernames):
        return True

    if telegram_id and telegram_id in whl_ids:
        return True

    return False
