# coding: utf-8

import json

from django import http
from django.views.generic import base

from tasha import models


class UnistatView(base.View):
    def get(self, request):
        metrics = []
        last_slack_metrics = models.SlackStatistics.objects.latest('updated_at')
        for (mkey, mvalue) in last_slack_metrics.statistics.items():
            metric_name = 'slack_%s_max' % mkey
            metrics.append([metric_name, mvalue])

        return http.HttpResponse(json.dumps(metrics), content_type='application/json')


class PingView(base.View):
    def get(self, request):
        return http.HttpResponse('pong')
