from django.forms import fields, ModelChoiceField, Form
from django.utils.translation import ugettext_lazy as _

from tasha.models import User


class UserField(ModelChoiceField):
    def __init__(self, **kwargs):
        defaults = {
            'queryset': User.objects.all(),
            'to_field_name': 'username',
            'error_messages': {
                'invalid_choice': _('Группа с username=%(value)s не найдена')
            }
        }
        defaults.update(kwargs)
        super().__init__(**defaults)


class RegistrationForm(Form):
    user = UserField(label=_('Имя пользователя'), required=True)
    telegram_id = fields.IntegerField(label=_('ID аккаунта телеграма'), required=True)


class SendMessageForm(Form):
    chat_id = fields.IntegerField(label='Chat ID', required=True)
    message = fields.CharField(label='Text to send', required=True)


class AddSlackBotForm(Form):
    chat_id = fields.IntegerField(label='Chat ID', required=True)
