import asyncio
import logging

from tasha.core import TashaUnit
from tasha.core.tasha_worker import cron_job, retry_on_exception
from tasha.lib.staff.sync import StaffAccountsPull

logger = logging.getLogger(__name__)


@cron_job(
    minute={30},
    timeout=3600,  # 60 мин для синка со стаффом
    run_at_startup=True,
)
@retry_on_exception()
async def sync_staff_users(ctx) -> None:
    async with ctx['db'].acquire_connection() as conn:
        async with TashaUnit(conn=conn, db_proxy=ctx['db'], bot=ctx['bot'], redis=ctx['redis']) as tu:
            staff_sync = await StaffAccountsPull.init(tu)
            await staff_sync.pull_staff_users()
    await asyncio.sleep(1)
