from logging.config import dictConfig

from tasha.config import settings
from tasha.core.tasha_worker import BaseWorkerSettings, get_cron_jobs, get_jobs
from . import cron_jobs, jobs
from ..lib.logging import LOGGING_CONFIG

dictConfig(LOGGING_CONFIG)


class WorkerSettings:
    on_startup = BaseWorkerSettings.on_startup
    on_shutdown = BaseWorkerSettings.on_shutdown
    redis_settings = BaseWorkerSettings.redis_settings
    max_tries = BaseWorkerSettings.max_tries
    max_jobs = BaseWorkerSettings.max_jobs

    queue_name = settings.ARQ_FAST_QUEUE_NAME
    functions = get_jobs(jobs)
    cron_jobs = get_cron_jobs(cron_jobs)
