import logging

from tasha.core import TashaUnit
from tasha.core.services.chat_scan_service.chat_scan_service import ChatScanService
from tasha.core.tasha_worker import job

logger = logging.getLogger(__name__)


@job()
async def scan_chat(ctx, chat_id: int) -> None:
    if not chat_id:
        logger.error('no chat_id provided')
        return

    async with ctx['db'].acquire_connection() as conn:
        async with TashaUnit(conn=conn, db_proxy=ctx['db'], bot=ctx['bot'], redis=ctx['redis']) as tu:
            chat_processor = ChatScanService(tu=tu)
            await chat_processor.scan(chat_id, ctx['client'], no_retry=ctx['is_last_try'])

