from logging.config import dictConfig

from tasha.config import settings
from tasha.core.tasha_worker import BaseWorkerSettings, get_cron_jobs, get_jobs
from tasha.lib.logging import LOGGING_CONFIG

from . import cron_jobs, jobs


dictConfig(LOGGING_CONFIG)


class WorkerSettings:
    on_startup = BaseWorkerSettings.on_startup
    on_shutdown = BaseWorkerSettings.on_shutdown
    redis_settings = BaseWorkerSettings.redis_settings
    max_tries = BaseWorkerSettings.max_tries
    max_jobs = BaseWorkerSettings.max_jobs

    # job_timeout = 1800  # 30 min
    # keep_result = 0
    queue_name = settings.ARQ_SLOW_QUEUE_NAME
    functions = get_jobs(jobs)
    cron_jobs = get_cron_jobs(cron_jobs)
