"""squashed everything

Revision ID: 0001
Revises:
Create Date: 2021-04-02 10:25:29.615734+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0001'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    op.create_table('list_aircraft',
        sa.Column('aircraft_id', sa.Integer(), nullable=False),
        sa.Column('name', sa.String(length=64), nullable=False),
        sa.PrimaryKeyConstraint('aircraft_id', name=op.f('pk__list_aircraft')),
        sa.UniqueConstraint('name', name=op.f('uq__list_aircraft__name'))
    )
    op.create_table('list_airline',
        sa.Column('airline_id', sa.Integer(), nullable=False),
        sa.Column('code', sa.String(length=8), nullable=False),
        sa.Column('name', sa.String(length=64), nullable=False),
        sa.Column('full_name', sa.String(length=256), nullable=False),
        sa.PrimaryKeyConstraint('airline_id', name=op.f('pk__list_airline')),
        sa.UniqueConstraint('code', name=op.f('uq__list_airline__code')),
        sa.UniqueConstraint('name', name=op.f('uq__list_airline__name'))
    )
    op.create_table('list_city',
        sa.Column('city_id', sa.Integer(), nullable=False),
        sa.Column('code', sa.String(length=16), nullable=False),
        sa.PrimaryKeyConstraint('city_id', name=op.f('pk__list_city'))
    )
    op.create_table('list_company',
        sa.Column('company_id', sa.Integer(), nullable=False),
        sa.Column('name', sa.String(length=32), nullable=False),
        sa.Column('aeroclub_company_id', sa.Integer(), nullable=True),
        sa.Column('aeroclub_company_uid', sa.String(length=64), nullable=True),
        sa.PrimaryKeyConstraint('company_id', name=op.f('pk__list_company'))
    )
    op.create_table('list_purpose',
        sa.Column('purpose_id', sa.Integer(), nullable=False),
        sa.Column('name', sa.String(length=128), nullable=False),
        sa.Column('name_en', sa.String(length=128), nullable=False),
        sa.Column('kind', sa.Enum('any', 'travel', 'conf_inner', 'conf_external',
                                  name='purposekind'), nullable=False),
        sa.Column('aeroclub_grade', sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint('purpose_id', name=op.f('pk__list_purpose'))
    )
    op.create_table('list_service_provider',
        sa.Column('service_type', sa.Enum('avia', 'hotel', 'rail',
                                          name='servicetype'), nullable=False),
        sa.Column('code', sa.String(length=8), nullable=False),
        sa.Column('name', sa.String(length=40), nullable=False),
        sa.Column('name_en', sa.String(length=40), nullable=False),
        sa.PrimaryKeyConstraint('service_type', 'code', name=op.f('pk__list_service_provider'))
    )
    op.create_table('list_airport',
        sa.Column('airport_id', sa.Integer(), nullable=False),
        sa.Column('name', sa.String(length=16), nullable=False),
        sa.Column('city_id', sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(['city_id'], ['list_city.city_id'],
                                name=op.f('fk__list_airport__city_id__list_city')),
        sa.PrimaryKeyConstraint('airport_id',
                                name=op.f('pk__list_airport'))
    )
    op.create_table('list_station',
        sa.Column('station_id', sa.Integer(), nullable=False),
        sa.Column('name', sa.String(length=16), nullable=False),
        sa.Column('city_id', sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(['city_id'], ['list_city.city_id'],
                                name=op.f('fk__list_station__city_id__list_city')),
        sa.PrimaryKeyConstraint('station_id', name=op.f('pk__list_station'))
    )
    op.create_table('person',
        sa.Column('person_id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('uid', sa.String(length=64), nullable=False),
        sa.Column('external_uid', sa.String(length=64), nullable=False),
        sa.Column('aeroclub_profile_id', sa.Integer(), nullable=True),
        sa.Column('login', sa.String(length=64), nullable=False),
        sa.Column('first_name', sa.String(length=64), nullable=False),
        sa.Column('last_name', sa.String(length=64), nullable=False),
        sa.Column('middle_name', sa.String(length=64), nullable=True),
        sa.Column('middle_name_en', sa.String(length=64), nullable=True),
        sa.Column('first_name_en', sa.String(length=64), nullable=True),
        sa.Column('last_name_en', sa.String(length=64), nullable=True),
        sa.Column('first_name_ac', sa.String(length=64), nullable=True),
        sa.Column('last_name_ac', sa.String(length=64), nullable=True),
        sa.Column('middle_name_ac', sa.String(length=64), nullable=True),
        sa.Column('first_name_ac_en', sa.String(length=64), nullable=True),
        sa.Column('last_name_ac_en', sa.String(length=64), nullable=True),
        sa.Column('middle_name_ac_en', sa.String(length=64), nullable=True),
        sa.Column('gender', sa.Enum('male', 'female', name='gender'), nullable=True),
        sa.Column('date_of_birth', sa.Date(), nullable=True),
        sa.Column('phone_number', sa.String(length=32), nullable=True),
        sa.Column('company_id', sa.Integer(), nullable=True),
        sa.Column('is_coordinator', sa.Boolean(), nullable=False),
        sa.Column('is_dismissed', sa.Boolean(), nullable=False),
        sa.Column('email', sa.String(length=64), nullable=True),
        sa.ForeignKeyConstraint(['company_id'], ['list_company.company_id'],
                                name=op.f('fk__person__company_id__list_company')),
        sa.PrimaryKeyConstraint('person_id', name=op.f('pk__person'))
    )
    op.create_index('person_table__aeroclub_profile_id', 'person',
                    ['aeroclub_profile_id'], unique=False)
    op.create_index('person_table__external_uid', 'person', ['external_uid'], unique=False)
    op.create_table('bonus_card',
        sa.Column('bonus_card_id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('person_id', sa.Integer(), nullable=False),
        sa.Column('number', sa.String(length=64), nullable=False),
        sa.Column('service_provider_type', sa.Enum('avia', 'hotel', 'rail',
                                                   name='servicetype'), nullable=False),
        sa.Column('service_provider_code', sa.String(length=8), nullable=False),
        sa.ForeignKeyConstraint(['person_id'], ['person.person_id'],
                                name=op.f('fk__bonus_card_table__person_id__person')),
        sa.ForeignKeyConstraint(
            ['service_provider_type', 'service_provider_code'],
            ['list_service_provider.service_type', 'list_service_provider.code'],
            name=op.f('fk__bonus_card__provider_type_provider_code__list_service_provider')
        ),
        sa.PrimaryKeyConstraint('bonus_card_id', name=op.f('pk__bonus_card_table'))
    )
    op.create_table('person_document',
        sa.Column('document_id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('person_id', sa.Integer(), nullable=False),
        sa.Column('document_type',
                  sa.Enum('other', 'passport', 'external_passport', 'visa', 'bonus_card',
                          name='documenttype'), nullable=False),
        sa.Column('series', sa.String(length=8), nullable=True),
        sa.Column('number', sa.String(length=32), nullable=True),
        sa.Column('issued_by', sa.String(length=256), nullable=True),
        sa.Column('issued_on', sa.Date(), nullable=True),
        sa.Column('expires_on', sa.Date(), nullable=True),
        sa.Column('citizenship', sa.Enum('OTHER', 'RU', 'BY', 'UA', 'KZ', 'KG', 'AM',
                                         name='citizenship'), nullable=False),
        sa.Column('first_name', sa.String(length=50), nullable=False),
        sa.Column('last_name', sa.String(length=50), nullable=False),
        sa.Column('middle_name', sa.String(length=50), nullable=True),
        sa.Column('description', sa.String(length=256), nullable=True),
        sa.ForeignKeyConstraint(['person_id'], ['person.person_id'],
                                name=op.f('fk__person_document__person_id__person')),
        sa.PrimaryKeyConstraint('document_id', name=op.f('pk__person_document'))
    )
    op.create_table('person_relationship',
        sa.Column('role', sa.Enum('chief', 'hr_partner', name='personrole'), nullable=False),
        sa.Column('owner_id', sa.Integer(), nullable=False),
        sa.Column('dependant_id', sa.Integer(), nullable=False),
        sa.Column('is_direct', sa.Boolean(), nullable=True),
        sa.ForeignKeyConstraint(['dependant_id'], ['person.person_id'],
                                name=op.f('fk__person_relationship__dependant_id__person')),
        sa.ForeignKeyConstraint(['owner_id'], ['person.person_id'],
                                name=op.f('fk__person_relationship__owner_id__person')),
        sa.PrimaryKeyConstraint('role', 'owner_id', 'dependant_id',
                                name=op.f('pk__person_relationship'))
    )
    op.create_table('trip',
        sa.Column('trip_id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('staff_trip_uuid', sa.String(length=36), nullable=True),
        sa.Column('status', sa.Enum('new', 'cancelled', 'closed',
                                    name='tripstatus'), nullable=False),
        sa.Column('city_from', sa.String(length=32), nullable=True),
        sa.Column('city_to', sa.String(length=32), nullable=True),
        sa.Column('date_from', sa.Date(), nullable=False),
        sa.Column('date_to', sa.Date(), nullable=False),
        sa.Column('issue_travel', sa.String(length=16), nullable=True),
        sa.Column('author_id', sa.Integer(), nullable=False),
        sa.Column('comment', sa.String(length=4096), nullable=False),
        sa.Column('aeroclub_city_from_id', sa.Integer(), nullable=True),
        sa.Column('aeroclub_city_to_id', sa.Integer(), nullable=True),
        sa.Column('chat_id', sa.String(length=64), nullable=True),
        sa.ForeignKeyConstraint(['author_id'], ['person.person_id'],
                                name=op.f('fk__trip__author_id__person')),
        sa.PrimaryKeyConstraint('trip_id', name=op.f('pk__trip'))
    )
    op.create_index('trip__date_from', 'trip', ['date_from'], unique=False)
    op.create_index('trip__issue_travel', 'trip', ['issue_travel'], unique=False)
    op.create_table('link_trip_purpose',
        sa.Column('trip_id', sa.Integer(), nullable=False),
        sa.Column('purpose_id', sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(['purpose_id'], ['list_purpose.purpose_id'],
                                name=op.f('fk__link_trip_purpose__purpose_id__list_purpose')),
        sa.ForeignKeyConstraint(['trip_id'], ['trip.trip_id'],
                                name=op.f('fk__link_trip_purpose__trip_id__trip')),
        sa.PrimaryKeyConstraint('trip_id', 'purpose_id',
                                name=op.f('pk__link_trip_purpose'))
    )
    op.create_table('person_trip',
        sa.Column('trip_id', sa.Integer(), nullable=False),
        sa.Column('person_id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('city_from', sa.String(length=32), nullable=True),
        sa.Column('status', sa.Enum('draft', 'new', 'executing', 'executed', 'cancelled', 'closed',
                                    name='persontripstatus'), nullable=False),
        sa.Column('is_approved', sa.Boolean(), nullable=True),
        sa.Column('is_authorized', sa.Boolean(), nullable=True),
        sa.Column('description', sa.String(length=2048), nullable=True),
        sa.Column('gap_date_from', sa.Date(), nullable=True),
        sa.Column('gap_date_to', sa.Date(), nullable=True),
        sa.Column('is_hidden', sa.Boolean(), nullable=False),
        sa.Column('with_days_off', sa.Boolean(), nullable=False),
        sa.Column('compensation_type', sa.Enum('money', 'days_off',
                                               name='tripdaysoffcompensations'), nullable=True),
        sa.Column('need_visa', sa.Boolean(), nullable=False),
        sa.Column('aeroclub_journey_id', sa.Integer(), nullable=True),
        sa.Column('aeroclub_trip_id', sa.Integer(), nullable=True),
        sa.Column('aeroclub_city_from_id', sa.Integer(), nullable=True),
        sa.Column('aeroclub_last_message_id', sa.Integer(), nullable=True),
        sa.Column('chat_id', sa.String(length=64), nullable=True),
        sa.Column('manager_chat_id', sa.String(length=64), nullable=True),
        sa.Column('manager_id', sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(['manager_id'], ['person.person_id'],
                                name=op.f('fk__person_trip__manager_id__person')),
        sa.ForeignKeyConstraint(['person_id'], ['person.person_id'],
                                name=op.f('fk__person_trip__person_id__person')),
        sa.ForeignKeyConstraint(['trip_id'], ['trip.trip_id'],
                                name=op.f('fk__person_trip__trip_id__trip')),
        sa.PrimaryKeyConstraint('trip_id', 'person_id',
                                name=op.f('pk__person_trip'))
    )
    op.create_index('aeroclub__person_trip_id', 'person_trip',
                    ['aeroclub_journey_id', 'aeroclub_trip_id'], unique=False)
    op.create_index('person_trip__aeroclub_city_from_id', 'person_trip',
                    ['aeroclub_city_from_id'], unique=False)
    op.create_table('trip_conf_details',
        sa.Column('trip_id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('conference_name', sa.String(length=128), nullable=True),
        sa.Column('tracker_issue', sa.String(length=16), nullable=True),
        sa.Column('price', sa.String(length=64), nullable=True),
        sa.Column('promo_code', sa.String(length=128), nullable=True),
        sa.Column('conf_date_from', sa.Date(), nullable=False),
        sa.Column('conf_date_to', sa.Date(), nullable=False),
        sa.Column('conference_url', sa.String(length=128), nullable=True),
        sa.Column('participation_terms', sa.Text(), nullable=True),
        sa.Column('cancellation_terms', sa.Text(), nullable=True),
        sa.Column('ticket_type', sa.String(length=128), nullable=True),
        sa.Column('is_another_city', sa.Boolean(), nullable=False),
        sa.ForeignKeyConstraint(['trip_id'], ['trip.trip_id'],
                                name=op.f('fk__trip_conf_details__trip_id__trip')),
        sa.PrimaryKeyConstraint('trip_id', name=op.f('pk__trip_conf_details'))
    )
    op.create_index('trip_conf_details__tracker_issue', 'trip_conf_details',
                    ['tracker_issue'], unique=False)
    op.create_table('link_persontrip_document',
        sa.Column('trip_id', sa.Integer(), nullable=False),
        sa.Column('person_id', sa.Integer(), nullable=False),
        sa.Column('document_id', sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ['document_id'],
            ['person_document.document_id'],
            name=op.f('fk__link_persontrip_document__document_id__person_document')
        ),
        sa.ForeignKeyConstraint(
            ['trip_id', 'person_id'],
            ['person_trip.trip_id', 'person_trip.person_id'],
            name=op.f('fk__link_persontrip_document__trip_id_person_id__person_trip')
        ),
        sa.PrimaryKeyConstraint(
            'trip_id',
            'person_id',
            'document_id',
            name=op.f('pk__link_persontrip_document')
        )
    )
    op.create_table('link_persontrip_purpose',
        sa.Column('trip_id', sa.Integer(), nullable=False),
        sa.Column('person_id', sa.Integer(), nullable=False),
        sa.Column('purpose_id', sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ['purpose_id'],
            ['list_purpose.purpose_id'],
            name=op.f('fk__link_persontrip_purpose__purpose_id__list_purpose')
        ),
        sa.ForeignKeyConstraint(
            ['trip_id', 'person_id'],
            ['person_trip.trip_id', 'person_trip.person_id'],
            name=op.f('fk__link_persontrip_purpose__trip_id_person_id__person_trip')
        ),
        sa.PrimaryKeyConstraint('trip_id', 'person_id', 'purpose_id',
                                name=op.f('pk__link_persontrip_purpose'))
    )
    op.create_table('link_trip_follower',
        sa.Column('trip_id', sa.Integer(), nullable=False),
        sa.Column('person_id', sa.Integer(), nullable=False),
        sa.Column('follower_id', sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(['follower_id'], ['person.person_id'],
                                name=op.f('fk__link_trip_follower__follower_id__person')),
        sa.ForeignKeyConstraint(
            ['trip_id', 'person_id'],
            ['person_trip.trip_id', 'person_trip.person_id'],
            name=op.f('fk__link_trip_follower__trip_id_person_id__person_trip')
        ),
        sa.PrimaryKeyConstraint('trip_id', 'person_id', 'follower_id',
                                name=op.f('pk__link_trip_follower'))
    )
    op.create_table('link_trip_guest',
        sa.Column('trip_id', sa.Integer(), nullable=False),
        sa.Column('person_id', sa.Integer(), nullable=False),
        sa.Column('guest_id', sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(['guest_id'], ['person.person_id'],
                                name=op.f('fk__link_trip_guest__guest_id__person')),
        sa.ForeignKeyConstraint(
            ['trip_id', 'person_id'],
            ['person_trip.trip_id', 'person_trip.person_id'],
            name=op.f('fk__link_trip_guest__trip_id_person_id__person_trip')
        ),
        sa.PrimaryKeyConstraint('trip_id', 'person_id', 'guest_id',
                                name=op.f('pk__link_trip_guest'))
    )
    op.create_table('person_trip_conf_details',
        sa.Column('trip_id', sa.Integer(), nullable=False),
        sa.Column('person_id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('role', sa.Enum('speaker', 'listener', 'recruiter',
                                  name='conferenceparticiationtype'), nullable=False),
        sa.Column('tracker_issue', sa.String(length=16), nullable=True),
        sa.Column('price', sa.String(length=64), nullable=True),
        sa.Column('promo_code', sa.String(length=128), nullable=True),
        sa.Column('discount', sa.String(length=128), nullable=True),
        sa.Column('badge_position', sa.String(length=128), nullable=True),
        sa.Column('badge_name', sa.String(length=128), nullable=True),
        sa.Column('comment', sa.String(length=256), nullable=False),
        sa.Column('is_hr_approved', sa.Boolean(), nullable=False),
        sa.Column('is_paid_by_host', sa.Boolean(), nullable=False),
        sa.Column('presentation_topic', sa.String(length=128), nullable=True),
        sa.ForeignKeyConstraint(['person_id'], ['person.person_id'],
                                name=op.f('fk__person_trip_conf_details__person_id__person')),
        sa.ForeignKeyConstraint(
            ['trip_id', 'person_id'],
            ['person_trip.trip_id', 'person_trip.person_id'],
            name=op.f('fk__person_trip_conf_details__trip_id_person_id__person_trip')
        ),
        sa.ForeignKeyConstraint(
            ['trip_id'],
            ['trip.trip_id'],
            name=op.f('fk__person_trip_conf_details__trip_id__trip')
        ),
        sa.PrimaryKeyConstraint('trip_id', 'person_id', name=op.f('pk__person_trip_conf_details'))
    )
    op.create_index('person_trip_conf_details__tracker_issue', 'person_trip_conf_details',
                    ['tracker_issue'], unique=False)
    op.create_table('service',
        sa.Column('service_id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('trip_id', sa.Integer(), nullable=False),
        sa.Column('person_id', sa.Integer(), nullable=False),
        sa.Column('type', sa.Enum('avia', 'hotel', 'rail', name='servicetype'), nullable=False),
        sa.Column('ordering', sa.Integer(), nullable=False),
        sa.Column(
            'status',
            sa.Enum('draft', 'new', 'in_progress', 'reserved', 'executed', 'cancelled', 'deleted',
                    name='servicestatus'),
            nullable=False
        ),
        sa.Column('boarding_pass', sa.String(length=128), nullable=True),
        sa.Column('is_broken', sa.Boolean(), nullable=True),
        sa.Column('aeroclub_service_id', sa.Integer(), nullable=True),
        sa.Column('aeroclub_order_id', sa.Integer(), nullable=True),
        sa.Column('aeroclub_document_id', sa.Integer(), nullable=True),
        sa.Column('is_from_aeroclub', sa.Boolean(), nullable=False),
        sa.Column('is_authorized', sa.Boolean(), nullable=False),
        sa.ForeignKeyConstraint(
            ['trip_id', 'person_id'],
            ['person_trip.trip_id', 'person_trip.person_id'],
            name=op.f('fk__service__trip_id_person_id__person_trip')
        ),
        sa.PrimaryKeyConstraint('service_id', name=op.f('pk__service'))
    )
    op.create_table('trip_travel_details',
        sa.Column('trip_id', sa.Integer(), nullable=False),
        sa.Column('person_id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('city_id', sa.Integer(), nullable=False),
        sa.Column('tracker_issue', sa.String(length=16), nullable=True),
        sa.Column('is_created_on_provider', sa.Boolean(), nullable=False),
        sa.Column('need_visa_assistance', sa.Boolean(), nullable=False),
        sa.Column('taxi_date_from', sa.Date(), nullable=True),
        sa.Column('taxi_date_to', sa.Date(), nullable=True),
        sa.Column('taxi_activated', sa.Boolean(), nullable=False),
        sa.Column('taxi_access_phone', sa.String(length=14), nullable=True),
        sa.Column('comment', sa.String(length=256), nullable=False),
        sa.ForeignKeyConstraint(['city_id'], ['list_city.city_id'],
                                name=op.f('fk__trip_travel_details__city_id__list_city')),
        sa.ForeignKeyConstraint(['person_id'], ['person.person_id'],
                                name=op.f('fk__trip_travel_details__person_id__person')),
        sa.ForeignKeyConstraint(
            ['trip_id', 'person_id'],
            ['person_trip.trip_id', 'person_trip.person_id'],
            name=op.f('fk__trip_travel_details__trip_id_person_id__person_trip')
        ),
        sa.ForeignKeyConstraint(['trip_id'], ['trip.trip_id'],
                                name=op.f('fk__trip_travel_details__trip_id__trip')),
        sa.PrimaryKeyConstraint('trip_id', 'person_id', name=op.f('pk__trip_travel_details'))
    )
    op.create_index('trip_travel_details__tracker_issue', 'trip_travel_details',
                    ['tracker_issue'], unique=False)
    op.create_table('service_avia',
        sa.Column('service_id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('has_tickets', sa.Boolean(), nullable=False),
        sa.Column('airline_id', sa.Integer(), nullable=True),
        sa.Column('aircraft_id', sa.Integer(), nullable=True),
        sa.Column('flight_number', sa.String(length=8), nullable=True),
        sa.Column('departure_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('arrival_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('departure_airport_id', sa.Integer(), nullable=True),
        sa.Column('arrival_airport_id', sa.Integer(), nullable=True),
        sa.Column('seat', sa.String(length=4), nullable=True),
        sa.Column('price', sa.Numeric(precision=8, scale=2), nullable=False),
        sa.Column('currency', sa.Enum('other', 'uah', 'rub', 'usd', 'eur',
                                      name='currencytype'), nullable=True),
        sa.Column('overpaid', sa.Boolean(), nullable=False),
        sa.ForeignKeyConstraint(['aircraft_id'], ['list_aircraft.aircraft_id'],
                                name=op.f('fk__service_avia__aircraft_id__list_aircraft')),
        sa.ForeignKeyConstraint(['airline_id'], ['list_airline.airline_id'],
                                name=op.f('fk__service_avia__airline_id__list_airline')),
        sa.ForeignKeyConstraint(['arrival_airport_id'], ['list_airport.airport_id'],
                                name=op.f('fk__service_avia__arrival_airport_id__list_airport')),
        sa.ForeignKeyConstraint(['departure_airport_id'], ['list_airport.airport_id'],
                                name=op.f('fk__service_avia__departure_airport_id__list_airport')),
        sa.ForeignKeyConstraint(['service_id'], ['service.service_id'],
                                name=op.f('fk__service_avia__service_id__service')),
        sa.PrimaryKeyConstraint('service_id', name=op.f('pk__service_avia'))
    )
    op.create_table('service_hotel',
        sa.Column('service_id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('has_hotel', sa.Boolean(), nullable=False),
        sa.Column('overpaid', sa.Boolean(), nullable=False),
        sa.Column('comment', sa.String(length=256), nullable=False),
        sa.ForeignKeyConstraint(['service_id'], ['service.service_id'],
                                name=op.f('fk__service_hotel__service_id__service')),
        sa.PrimaryKeyConstraint('service_id', name=op.f('pk__service_hotel'))
    )
    op.create_table('service_railway',
        sa.Column('service_id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('has_tickets', sa.Boolean(), nullable=False),
        sa.Column('departure_station_id', sa.Integer(), nullable=True),
        sa.Column('arrival_station_id', sa.Integer(), nullable=True),
        sa.Column('train_number', sa.String(length=16), nullable=True),
        sa.Column('price', sa.Numeric(precision=8, scale=2), nullable=False),
        sa.Column('currency', sa.Enum('other', 'uah', 'rub', 'usd', 'eur',
                                      name='currencytype'), nullable=True),
        sa.Column('overpaid', sa.Boolean(), nullable=False),
        sa.ForeignKeyConstraint(['arrival_station_id'], ['list_station.station_id'],
                                name=op.f('fk__service_railway__arrival_station_id__list_station')),
        sa.ForeignKeyConstraint(
            ['departure_station_id'],
            ['list_station.station_id'],
            name=op.f('fk__service_railway__departure_station_id__list_station')
        ),
        sa.ForeignKeyConstraint(['service_id'], ['service.service_id'],
                                name=op.f('fk__service_railway__service_id__service')),
        sa.PrimaryKeyConstraint('service_id', name=op.f('pk__service_railway'))
    )


def downgrade():
    op.drop_table('service_railway')
    op.drop_table('service_hotel')
    op.drop_table('service_avia')
    op.drop_index('trip_travel_details__tracker_issue', table_name='trip_travel_details')
    op.drop_table('trip_travel_details')
    op.drop_table('service')
    op.drop_index('person_trip_conf_details__tracker_issue', table_name='person_trip_conf_details')
    op.drop_table('person_trip_conf_details')
    op.drop_table('link_trip_guest')
    op.drop_table('link_trip_follower')
    op.drop_table('link_persontrip_purpose')
    op.drop_table('link_persontrip_document')
    op.drop_index('trip_conf_details__tracker_issue', table_name='trip_conf_details')
    op.drop_table('trip_conf_details')
    op.drop_index('person_trip__aeroclub_city_from_id', table_name='person_trip')
    op.drop_index('aeroclub__person_trip_id', table_name='person_trip')
    op.drop_table('person_trip')
    op.drop_table('link_trip_purpose')
    op.drop_index('trip__issue_travel', table_name='trip')
    op.drop_index('trip__date_from', table_name='trip')
    op.drop_table('trip')
    op.drop_table('person_relationship')
    op.drop_table('person_document')
    op.drop_table('bonus_card')
    op.drop_index('person_table__external_uid', table_name='person')
    op.drop_index('person_table__aeroclub_profile_id', table_name='person')
    op.drop_table('person')
    op.drop_table('list_station')
    op.drop_table('list_airport')
    op.drop_table('list_service_provider')
    op.drop_table('list_purpose')
    op.drop_table('list_company')
    op.drop_table('list_city')
    op.drop_table('list_airline')
    op.drop_table('list_aircraft')

    op.execute('DROP TYPE citizenship;')
    op.execute('DROP TYPE conferenceparticiationtype;')
    op.execute('DROP TYPE currencytype;')
    op.execute('DROP TYPE documenttype;')
    op.execute('DROP TYPE gender;')
    op.execute('DROP TYPE personrole;')
    op.execute('DROP TYPE persontripstatus;')
    op.execute('DROP TYPE purposekind;')
    op.execute('DROP TYPE servicestatus;')
    op.execute('DROP TYPE servicetype;')
    op.execute('DROP TYPE tripdaysoffcompensations;')
    op.execute('DROP TYPE tripstatus;')
