"""add is_another_city to person trip conf

Revision ID: 0002
Revises: 0001
Create Date: 2021-06-08 12:30:12.638744+00:00

"""
from alembic import op
import sqlalchemy as sa

from intranet.trip.alembic.utils import upgrade_enum


# revision identifiers, used by Alembic.
revision = '0002'
down_revision = '0001'
branch_labels = None
depends_on = None


def upgrade():
    op.add_column(
        'person_trip_conf_details',
        sa.Column('is_another_city', sa.Boolean(), nullable=True)
    )
    op.execute('''
        UPDATE person_trip_conf_details
        SET is_another_city = (
            SELECT is_another_city
            FROM trip_conf_details
            WHERE trip_conf_details.trip_id = person_trip_conf_details.trip_id
        )
    ''')
    op.execute('''
        UPDATE person_trip_conf_details
        SET is_another_city = 'f'
        WHERE is_another_city IS NULL
    ''')
    op.alter_column('person_trip_conf_details', 'is_another_city', nullable=False)

    upgrade_enum(
        name='citizenship',
        values=['OTHER', 'RU', 'BY', 'UA', 'KZ', 'KG', 'AM', 'UZ', 'LV'],
        columns=[
            ('person_document', 'citizenship'),
        ]
    )

    op.alter_column('trip_conf_details', 'price', type_=sa.String(length=256))


def downgrade():
    op.alter_column('trip_conf_details', 'price', type_=sa.String(length=64))

    upgrade_enum(
        name='citizenship',
        values=['OTHER', 'RU', 'BY', 'UA', 'KZ', 'KG', 'AM'],
        columns=[
            ('person_document', 'citizenship'),
        ]
    )

    op.drop_column('person_trip_conf_details', 'is_another_city')
