"""added country_from and country_to to trip

Revision ID: 0005
Revises: 0004
Create Date: 2021-07-02 07:58:11.298170+00:00

"""
from alembic import op
import sqlalchemy as sa


revision = '0005'
down_revision = '0004'
branch_labels = None
depends_on = None


def upgrade():
    op.add_column(
        'person_trip',
        sa.Column('country_from', sa.String(length=128), nullable=True)
    )
    op.add_column(
        'trip',
        sa.Column('country_from', sa.String(length=128), nullable=True)
    )
    op.add_column(
        'trip',
        sa.Column('country_to', sa.String(length=128), nullable=True)
    )
    op.alter_column('person_trip', 'city_from', type_=sa.String(length=128), nullable=True)
    op.alter_column('trip', 'city_from', type_=sa.String(length=128), nullable=True)
    op.alter_column('trip', 'city_to', type_=sa.String(length=128), nullable=True)


def downgrade():
    op.drop_column('person_trip', 'country_from')
    op.drop_column('trip', 'country_from')
    op.drop_column('trip', 'country_to')
    op.alter_column('person_trip', 'city_from', type_=sa.String(length=32), nullable=True)
    op.alter_column('trip', 'city_from', type_=sa.String(length=32), nullable=True)
    op.alter_column('trip', 'city_to', type_=sa.String(length=32), nullable=True)
