"""added is_active to person

Revision ID: 0006
Revises: 0005
Create Date: 2021-07-05 16:36:15.000000+00:00

"""
from alembic import op
import sqlalchemy as sa


revision = '0006'
down_revision = '0005'
branch_labels = None
depends_on = None


def upgrade():
    op.add_column(
        'person',
        sa.Column('is_active', sa.Boolean(), nullable=True)
    )
    op.execute('''
        UPDATE person
        SET is_active = 't'
        WHERE is_dismissed = 'f'
    ''')
    op.execute('''
        UPDATE person
        SET is_active = 'f'
        WHERE is_active IS NULL
    ''')
    op.alter_column('person', 'is_active', nullable=False)


def downgrade():
    op.drop_column('person', 'is_active')
