"""drive integration columns

Revision ID: 0007
Revises: 0006
Create Date: 2021-07-22 13:06:50.908435+00:00

"""
from alembic import op
import sqlalchemy as sa


revision = '0007'
down_revision = '0006'
branch_labels = None
depends_on = None


def upgrade():
    op.alter_column('trip_travel_details', 'taxi_activated', new_column_name='is_taxi_activated')
    op.add_column(
        'trip_travel_details',
        sa.Column('is_drive_activated', sa.Boolean(), nullable=True),
    )
    op.add_column(
        'trip_travel_details',
        sa.Column('drive_org_id', sa.String(length=64), nullable=True),
    )
    op.add_column(
        'trip_travel_details',
        sa.Column('drive_user_id', sa.String(length=64), nullable=True),
    )
    op.execute('''
        UPDATE trip_travel_details
        SET is_drive_activated = 'f'
    ''')
    op.alter_column('trip_travel_details', 'is_drive_activated', nullable=False)


def downgrade():
    op.drop_column('trip_travel_details', 'is_drive_activated')
    op.drop_column('trip_travel_details', 'drive_org_id')
    op.drop_column('trip_travel_details', 'drive_user_id')
    op.alter_column('trip_travel_details', 'is_taxi_activated', new_column_name='taxi_activated')
