"""external_person table

Revision ID: 0010
Revises: 0009
Create Date: 2021-08-26 11:15:29.481060+00:00

"""
from alembic import op
import sqlalchemy as sa


revision = '0010'
down_revision = '0009'
branch_labels = None
depends_on = None


def upgrade():
    op.create_table('ext_person',
        sa.Column('ext_person_id', sa.Integer, primary_key=True),
        sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('name', sa.String(length=64), nullable=False),
        sa.Column('email', sa.String(length=256), nullable=False),
        sa.Column('person_id', sa.Integer, nullable=False),
        sa.Column('secret', sa.String(length=64), nullable=True),
        sa.Column('status', sa.Enum('pending', 'completed', 'cleaned',
                                    name='extpersonstatus'), nullable=False),
        sa.Column('aeroclub_profile_id', sa.Integer, nullable=True, default=None),
        sa.Column('data', sa.JSON, nullable=True),

        sa.PrimaryKeyConstraint('ext_person_id', name=op.f('pk__ext_person')),
        sa.ForeignKeyConstraint(['person_id'], ['person.person_id'],
                                name=op.f('fk__ext_person__person_id__person')),
    )


def downgrade():
    op.drop_table('ext_person')
    op.execute('DROP TYPE extpersonstatus;')
