"""country for company

Revision ID: 0011
Revises: 0010
Create Date: 2021-08-31 15:14:49.745260+00:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

from intranet.trip.alembic.utils import upgrade_enum


revision = '0011'
down_revision = '0010'
branch_labels = None
depends_on = None


def upgrade():
    op.add_column(
        'list_company',
        sa.Column(
            'country',
            postgresql.ENUM(
                'OTHER', 'RU', 'BY', 'UA', 'KZ', 'KG', 'AM', 'UZ', 'LV', 'TJ',
                name='citizenship',
                create_type=False,
            ),
            nullable=True,
        ),
    )
    upgrade_enum(
        name='persontripstatus',
        values=[
            'draft', 'new', 'executing', 'executed', 'cancelled', 'closed', 'verification',
        ],
        columns=[
            ('person_trip', 'status'),
        ]
    )
    upgrade_enum(
        name='servicestatus',
        values=[
            'draft',
            'new',
            'in_progress',
            'reserved',
            'executed',
            'cancelled',
            'deleted',
            'verification',
        ],
        columns=[
            ('service', 'status'),
        ]
    )


def downgrade():
    upgrade_enum(
        name='persontripstatus',
        values=['draft', 'new', 'executing', 'executed', 'cancelled', 'closed'],
        columns=[
            ('person_trip', 'status'),
        ]
    )
    upgrade_enum(
        name='servicestatus',
        values=[
            'draft', 'new', 'in_progress', 'reserved', 'executed', 'cancelled', 'deleted',
        ],
        columns=[
            ('service', 'status'),
        ]
    )
    op.drop_column('list_company', 'country')
