"""route_point table

Revision ID: 0012
Revises: 0011
Create Date: 2021-09-13 15:48:12.365290+00:00

"""
from alembic import op
import sqlalchemy as sa


revision = '0012'
down_revision = '0011'
branch_labels = None
depends_on = None


def upgrade():
    op.create_table('trip_route_point',
        sa.Column('point_id', sa.Integer(), primary_key=True),
        sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),

        sa.Column('trip_id', sa.Integer(), nullable=False),

        sa.Column('city', sa.String(length=64), nullable=False),
        sa.Column('country', sa.String(length=64), nullable=False),
        sa.Column('date', sa.Date(), nullable=False),
        sa.Column('aeroclub_city_id', sa.Integer(), nullable=True),
        sa.Column('is_start_city', sa.Boolean(), nullable=False, default=False),

        sa.ForeignKeyConstraint(
            ['trip_id'],
            ['trip.trip_id'],
            name=op.f('fk__trip_route_point__trip_id__trip')),
    )

    op.create_table('person_trip_route_point',
        sa.Column('point_id', sa.Integer(), primary_key=True),
        sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),

        sa.Column('trip_id', sa.Integer(), nullable=False),
        sa.Column('person_id', sa.Integer(), nullable=False),

        sa.Column('city', sa.String(length=64), nullable=False),
        sa.Column('country', sa.String(length=64), nullable=False),
        sa.Column('date', sa.Date(), nullable=False),
        sa.Column('aeroclub_city_id', sa.Integer(), nullable=True),
        sa.Column('is_start_city', sa.Boolean(), nullable=False, default=False),

        sa.ForeignKeyConstraint(
            ['trip_id', 'person_id'],
            ['person_trip.trip_id', 'person_trip.person_id'],
            name=op.f('fk__person_trip_route_point__trip_id_person_id__person_trip')),
    )


def downgrade():
    op.drop_table('trip_route_point')
    op.drop_table('person_trip_route_point')
