"""ext_person table update

Revision ID: 0013
Revises: 0012
Create Date: 2021-09-19 23:15:39.199868+00:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '0013'
down_revision = '0012'
branch_labels = None
depends_on = None


def upgrade():
    op.add_column('ext_person', sa.Column('date_of_birth', sa.Date(), nullable=True))
    op.add_column('ext_person', sa.Column('external_uid', sa.String(length=64), nullable=False))
    op.add_column('ext_person', sa.Column('first_name', sa.String(length=64), nullable=False))
    op.add_column('ext_person', sa.Column('first_name_en', sa.String(length=64), nullable=True))
    op.add_column('ext_person', sa.Column('gender', sa.Enum('male', 'female', name='gender'), nullable=True))
    op.add_column('ext_person', sa.Column('last_name', sa.String(length=64), nullable=False))
    op.add_column('ext_person', sa.Column('last_name_en', sa.String(length=64), nullable=True))
    op.add_column('ext_person', sa.Column('middle_name', sa.String(length=64), nullable=True))
    op.add_column('ext_person', sa.Column('middle_name_en', sa.String(length=64), nullable=True))
    op.add_column('ext_person', sa.Column('phone_number', sa.String(length=32), nullable=True))
    op.alter_column('ext_person', 'aeroclub_profile_id', nullable=True)
    op.create_index('ext_person_table__aeroclub_profile_id', 'ext_person', ['aeroclub_profile_id'], unique=False)
    op.create_index('ext_person_table__external_uid', 'ext_person', ['external_uid'], unique=False)
    op.drop_column('ext_person', 'data')

    op.alter_column('person_document', 'person_id', nullable=True)
    op.add_column('person_document', sa.Column('ext_person_id', sa.Integer(), nullable=True))
    op.create_foreign_key(
        op.f('fk__person_document__ext_person_id__ext_person'),
        'person_document',
        'ext_person',
        ['ext_person_id'],
        ['ext_person_id'],
    )
    op.alter_column('bonus_card', 'person_id', nullable=True)
    op.add_column('bonus_card', sa.Column('ext_person_id', sa.Integer(), nullable=True))
    op.create_foreign_key(
        op.f('fk__bonus_card__ext_person_id__ext_person'),
        'bonus_card',
        'ext_person',
        ['ext_person_id'],
        ['ext_person_id'],
    )


def downgrade():
    op.drop_constraint(op.f('fk__person_document__ext_person_id__ext_person'), 'person_document', type_='foreignkey')
    op.drop_column('person_document', 'ext_person_id')
    op.alter_column('person_document', 'person_id', nullable=False)

    op.drop_constraint(op.f('fk__bonus_card__ext_person_id__ext_person'), 'bonus_card', type_='foreignkey')
    op.drop_column('bonus_card', 'ext_person_id')
    op.alter_column('bonus_card', 'person_id', nullable=False)

    op.add_column('ext_person', sa.Column('data', postgresql.JSON(astext_type=sa.Text()), autoincrement=False, nullable=True))
    op.drop_index('ext_person_table__external_uid', table_name='ext_person')
    op.drop_index('ext_person_table__aeroclub_profile_id', table_name='ext_person')
    op.alter_column('ext_person', 'aeroclub_profile_id', nullable=False)
    op.drop_column('ext_person', 'phone_number')
    op.drop_column('ext_person', 'middle_name_en')
    op.drop_column('ext_person', 'middle_name')
    op.drop_column('ext_person', 'last_name_en')
    op.drop_column('ext_person', 'last_name')
    op.drop_column('ext_person', 'gender')
    op.drop_column('ext_person', 'first_name_en')
    op.drop_column('ext_person', 'first_name')
    op.drop_column('ext_person', 'external_uid')
    op.drop_column('ext_person', 'date_of_birth')
