"""documents soft delete

Revision ID: 0020
Revises: 0019
Create Date: 2021-12-24 12:39:00.000000+00:00

"""
import sqlalchemy as sa
from alembic import op

from intranet.trip.alembic.utils import add_not_nullable_boolean_column


revision = '0020'
down_revision = '0019'
branch_labels = None
depends_on = None


def upgrade():
    add_not_nullable_boolean_column('person_document', 'is_deleted', default=False)
    op.add_column('service', sa.Column('document_id', sa.Integer()))
    op.create_foreign_key(
        op.f('fk__service__document_id__person_document'),
        'service',
        'person_document',
        ['document_id'],
        ['document_id'],
    )


def downgrade():
    op.drop_column('person_document', 'is_deleted')
    op.drop_column('service', 'document_id')
