"""provider field

Revision ID: 0021
Revises: 0020
Create Date: 2022-01-13 13:06:00.000000+00:00

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql


revision = '0021'
down_revision = '0020'
branch_labels = None
depends_on = None


def upgrade():
    provider = postgresql.ENUM('aeroclub', 'aviacenter', name='provider')
    provider.create(op.get_bind())

    op.add_column(
        'list_company',
        sa.Column('provider', sa.Enum('aeroclub', 'aviacenter', name='provider'), nullable=True),
    )
    op.execute(f"UPDATE list_company SET provider = 'aeroclub' WHERE provider IS NULL")
    op.alter_column('list_company', 'provider', nullable=False)

    op.add_column(
        'person_trip',
        sa.Column('provider', sa.Enum('aeroclub', 'aviacenter', name='provider'), nullable=True),
    )
    op.execute(f"UPDATE person_trip SET provider = 'aeroclub' WHERE provider IS NULL")
    op.alter_column('person_trip', 'provider', nullable=False)


def downgrade():
    op.drop_column('person_trip', 'provider')
    op.drop_column('list_company', 'provider')
    op.execute('DROP TYPE provider;')
