"""add hosting table

Revision ID: 0023
Revises: 0022
Create Date: 2022-03-25 10:14:45.411511+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0023'
down_revision = '0022'
branch_labels = None
depends_on = None


def upgrade():
    op.create_table('list_holding',
        sa.Column('holding_id', sa.Integer(), nullable=False),
        sa.Column('name', sa.String(length=64), nullable=False),
        sa.PrimaryKeyConstraint('holding_id', name=op.f('pk__list_holding'))
    )
    op.execute(
        '''
            INSERT INTO list_holding(holding_id, name)
            VALUES (1, ' Яндекс')
        '''
    )
    op.add_column(
        'list_company',
        sa.Column('holding_id', sa.Integer(), nullable=True),
    )
    op.execute(
        '''
            UPDATE list_company
            SET holding_id = 1
        '''
    )
    op.alter_column(
        'list_company',
        sa.Column('holding_id', sa.Integer(), nullable=False),
    )

    op.create_foreign_key(
        op.f('fk__list_company__holding_id__list_holding'),
        'list_company',
        'list_holding',
        ['holding_id'],
        ['holding_id'],
    )


def downgrade():
    op.drop_column('list_company', 'holding_id')
    op.drop_table('list_holding')
