"""remove needless tables

Revision ID: 0024
Revises: 0023
Create Date: 2022-04-19 16:49:41.698038+00:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

revision = '0024'
down_revision = '0023'
branch_labels = None
depends_on = None


def upgrade():
    op.drop_table('service_hotel')
    op.drop_table('service_railway')
    op.drop_table('service_avia')
    op.drop_table('link_trip_follower')
    op.drop_table('list_aircraft')
    op.drop_table('list_airline')
    op.drop_table('list_airport')
    op.drop_table('link_trip_guest')
    op.drop_table('list_station')


def downgrade():
    op.create_table('list_station',
        sa.Column('station_id', sa.INTEGER(), server_default=sa.text("nextval('list_station_station_id_seq'::regclass)"), autoincrement=True, nullable=False),
        sa.Column('name', sa.VARCHAR(length=16), autoincrement=False, nullable=False),
        sa.Column('city_id', sa.INTEGER(), autoincrement=False, nullable=False),
        sa.ForeignKeyConstraint(['city_id'], ['list_city.city_id'], name='fk__list_station__city_id__list_city'),
        sa.PrimaryKeyConstraint('station_id', name='pk__list_station'),
        postgresql_ignore_search_path=False,
    )
    op.create_table('link_trip_guest',
        sa.Column('trip_id', sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column('person_id', sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column('guest_id', sa.INTEGER(), autoincrement=False, nullable=False),
        sa.ForeignKeyConstraint(['guest_id'], ['person.person_id'], name='fk__link_trip_guest__guest_id__person'),
        sa.ForeignKeyConstraint(['trip_id', 'person_id'], ['person_trip.trip_id', 'person_trip.person_id'], name='fk__link_trip_guest__trip_id_person_id__person_trip'),
        sa.PrimaryKeyConstraint('trip_id', 'person_id', 'guest_id', name='pk__link_trip_guest'),
    )
    op.create_table('list_airport',
        sa.Column('airport_id', sa.INTEGER(), server_default=sa.text("nextval('list_airport_airport_id_seq'::regclass)"), autoincrement=True, nullable=False),
        sa.Column('name', sa.VARCHAR(length=16), autoincrement=False, nullable=False),
        sa.Column('city_id', sa.INTEGER(), autoincrement=False, nullable=False),
        sa.ForeignKeyConstraint(['city_id'], ['list_city.city_id'], name='fk__list_airport__city_id__list_city'),
        sa.PrimaryKeyConstraint('airport_id', name='pk__list_airport'),
        postgresql_ignore_search_path=False,
    )
    op.create_table('list_airline',
        sa.Column('airline_id', sa.INTEGER(), server_default=sa.text("nextval('list_airline_airline_id_seq'::regclass)"), autoincrement=True, nullable=False),
        sa.Column('code', sa.VARCHAR(length=8), autoincrement=False, nullable=False),
        sa.Column('name', sa.VARCHAR(length=64), autoincrement=False, nullable=False),
        sa.Column('full_name', sa.VARCHAR(length=256), autoincrement=False, nullable=False),
        sa.PrimaryKeyConstraint('airline_id', name='pk__list_airline'),
        sa.UniqueConstraint('code', name='uq__list_airline__code'),
        sa.UniqueConstraint('name', name='uq__list_airline__name'),
        postgresql_ignore_search_path=False,
    )
    op.create_table('list_aircraft',
        sa.Column('aircraft_id', sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column('name', sa.VARCHAR(length=64), autoincrement=False, nullable=False),
        sa.PrimaryKeyConstraint('aircraft_id', name='pk__list_aircraft'),
        sa.UniqueConstraint('name', name='uq__list_aircraft__name')
    )
    op.create_table('link_trip_follower',
        sa.Column('trip_id', sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column('person_id', sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column('follower_id', sa.INTEGER(), autoincrement=False, nullable=False),
        sa.ForeignKeyConstraint(['follower_id'], ['person.person_id'], name='fk__link_trip_follower__follower_id__person'),
        sa.ForeignKeyConstraint(['trip_id', 'person_id'], ['person_trip.trip_id', 'person_trip.person_id'], name='fk__link_trip_follower__trip_id_person_id__person_trip'),
        sa.PrimaryKeyConstraint('trip_id', 'person_id', 'follower_id', name='pk__link_trip_follower'),
    )
    op.create_table('service_avia',
        sa.Column('service_id', sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column('created_at', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
        sa.Column('updated_at', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
        sa.Column('has_tickets', sa.BOOLEAN(), autoincrement=False, nullable=False),
        sa.Column('airline_id', sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column('aircraft_id', sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column('flight_number', sa.VARCHAR(length=8), autoincrement=False, nullable=True),
        sa.Column('departure_at', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
        sa.Column('arrival_at', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
        sa.Column('departure_airport_id', sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column('arrival_airport_id', sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column('seat', sa.VARCHAR(length=4), autoincrement=False, nullable=True),
        sa.Column('price', sa.NUMERIC(precision=8, scale=2), autoincrement=False, nullable=False),
        sa.Column('currency', postgresql.ENUM('other', 'uah', 'rub', 'usd', 'eur', name='currencytype'), autoincrement=False, nullable=True),
        sa.Column('overpaid', sa.BOOLEAN(), autoincrement=False, nullable=False),
        sa.ForeignKeyConstraint(['aircraft_id'], ['list_aircraft.aircraft_id'], name='fk__service_avia__aircraft_id__list_aircraft'),
        sa.ForeignKeyConstraint(['airline_id'], ['list_airline.airline_id'], name='fk__service_avia__airline_id__list_airline'),
        sa.ForeignKeyConstraint(['arrival_airport_id'], ['list_airport.airport_id'], name='fk__service_avia__arrival_airport_id__list_airport'),
        sa.ForeignKeyConstraint(['departure_airport_id'], ['list_airport.airport_id'], name='fk__service_avia__departure_airport_id__list_airport'),
        sa.ForeignKeyConstraint(['service_id'], ['service.service_id'], name='fk__service_avia__service_id__service'),
        sa.PrimaryKeyConstraint('service_id', name='pk__service_avia'),
    )
    op.create_table('service_railway',
        sa.Column('service_id', sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column('created_at', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
        sa.Column('updated_at', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
        sa.Column('has_tickets', sa.BOOLEAN(), autoincrement=False, nullable=False),
        sa.Column('departure_station_id', sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column('arrival_station_id', sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column('train_number', sa.VARCHAR(length=16), autoincrement=False, nullable=True),
        sa.Column('price', sa.NUMERIC(precision=8, scale=2), autoincrement=False, nullable=False),
        sa.Column('currency', postgresql.ENUM('other', 'uah', 'rub', 'usd', 'eur', name='currencytype'), autoincrement=False, nullable=True),
        sa.Column('overpaid', sa.BOOLEAN(), autoincrement=False, nullable=False),
        sa.ForeignKeyConstraint(['arrival_station_id'], ['list_station.station_id'], name='fk__service_railway__arrival_station_id__list_station'),
        sa.ForeignKeyConstraint(['departure_station_id'], ['list_station.station_id'], name='fk__service_railway__departure_station_id__list_station'),
        sa.ForeignKeyConstraint(['service_id'], ['service.service_id'], name='fk__service_railway__service_id__service'),
        sa.PrimaryKeyConstraint('service_id', name='pk__service_railway'),
    )
    op.create_table('service_hotel',
        sa.Column('service_id', sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column('created_at', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
        sa.Column('updated_at', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
        sa.Column('has_hotel', sa.BOOLEAN(), autoincrement=False, nullable=False),
        sa.Column('overpaid', sa.BOOLEAN(), autoincrement=False, nullable=False),
        sa.Column('comment', sa.VARCHAR(length=256), autoincrement=False, nullable=False),
        sa.ForeignKeyConstraint(['service_id'], ['service.service_id'], name='fk__service_hotel__service_id__service'),
        sa.PrimaryKeyConstraint('service_id', name='pk__service_hotel')
    )
