"""Create table billing_transaction

Revision ID: 0026
Revises: 0025
Create Date: 2022-06-29 10:45:09.246867+00:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = '0026'
down_revision = '0025'
branch_labels = None
depends_on = None


transaction_status_type = sa.Enum(
    'reserved',
    'paid',
    'ready_to_send',
    'completed',
    name='transactionstatus',
)
transaction_type = sa.Enum(
    'penalty',
    'refund',
    'purchase',
    name='transactiontype',
)


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        'billing_transaction',
        sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('transaction_id', sa.BigInteger(), nullable=False),
        sa.Column('company_id', sa.Integer(), nullable=False),
        sa.Column('service_id', sa.Integer(), nullable=True),
        sa.Column('general_service_id', sa.String(length=128), nullable=True),
        sa.Column(
            'service_type',
            postgresql.ENUM('avia', 'hotel', 'rail', name='servicetype', create_type=False),
            nullable=False,
        ),
        sa.Column('person_id', sa.Integer(), nullable=False),
        sa.Column('status', transaction_status_type, nullable=False),
        sa.Column('type', transaction_type, nullable=False),
        sa.Column('original_transaction_id', sa.BigInteger(), nullable=True),
        sa.Column('author_id', sa.Integer(), nullable=True),
        sa.Column('execution_date', sa.Date(), nullable=True),
        sa.Column('invoice_date', sa.Date(), nullable=True),
        sa.Column('price', sa.DECIMAL(), nullable=False),
        sa.Column('provider_fee', sa.DECIMAL(), nullable=False),
        sa.Column('yandex_fee', sa.DECIMAL(), nullable=False),
        sa.Column(
            'currency',
            postgresql.ENUM('other', 'uah', 'rub', 'usd', 'eur', name='currencytype', create_type=False),
            nullable=False,
        ),
        sa.Column('is_obsolete', sa.Boolean(), nullable=False),
        sa.ForeignKeyConstraint(
            ['author_id'],
            ['person.person_id'],
            name=op.f('fk__billing_transaction__author_id__person'),
        ),
        sa.ForeignKeyConstraint(
            ['company_id'],
            ['list_company.company_id'],
            name=op.f('fk__billing_transaction__company_id__list_company'),
        ),
        sa.ForeignKeyConstraint(
            ['person_id'],
            ['person.person_id'],
            name=op.f('fk__billing_transaction__person_id__person'),
        ),
        sa.ForeignKeyConstraint(
            ['service_id'],
            ['service.service_id'],
            name=op.f('fk__billing_transaction__service_id__service'),
        ),
    )
    op.create_index(
        'only_one_not_obsolete_transaction',
        'billing_transaction',
        ['transaction_id'],
        unique=True,
        postgresql_where='NOT is_obsolete',
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        'only_one_not_obsolete_transaction',
        table_name='billing_transaction',
        postgresql_where='is_obsolete',
    )
    op.drop_table('billing_transaction')
    transaction_status_type.drop(op.get_bind(), checkfirst=False)
    transaction_type.drop(op.get_bind(), checkfirst=False)
    # ### end Alembic commands ###
