"""add column email_confirmed_at

Revision ID: 0027
Revises: 0026
Create Date: 2022-06-30 12:37:43.693333+00:00

"""
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = '0027'
down_revision = '0026'
branch_labels = None
depends_on = None


def upgrade():
    op.add_column(
        'person',
        sa.Column('email_confirmed_at', sa.DateTime(timezone=True), nullable=True),
    )
    op.execute(
        '''
            UPDATE person
            SET email_confirmed_at = now()
        '''
    )


def downgrade():
    op.drop_column('person', 'email_confirmed_at')
