"""add domains for company

Revision ID: 0028
Revises: 0027
Create Date: 2022-07-04 07:15:29.430096+00:00

"""
from alembic import op
import sqlalchemy as sa

from intranet.trip.alembic.utils import add_not_nullable_boolean_column

# revision identifiers, used by Alembic.
revision = '0028'
down_revision = '0027'
branch_labels = None
depends_on = None


def upgrade():
    op.create_table('company_domain',
        sa.Column('company_id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('domain', sa.String(length=128), nullable=True),
        sa.ForeignKeyConstraint(['company_id'], ['list_company.company_id'],
                                name=op.f('fk__company_domain__company_id__list_company')),
        sa.PrimaryKeyConstraint('company_id', 'domain',
                                name=op.f('pk__company_domain')),
    )
    add_not_nullable_boolean_column('list_company', 'default_active', default=True)


def downgrade():
    op.drop_column('list_company', 'default_active')
    op.drop_table('company_domain')
