"""transaction_id is uuid

Revision ID: 0029
Revises: 0028
Create Date: 2022-07-07 16:45:27.687537+00:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '0029'
down_revision = '0028'
branch_labels = None
depends_on = None


def upgrade():
    op.add_column('billing_transaction', sa.Column('trip_id', sa.Integer(), nullable=False))

    op.drop_column('billing_transaction', 'transaction_id')
    op.add_column('billing_transaction', sa.Column('transaction_id', postgresql.UUID(), nullable=False))

    op.drop_column('billing_transaction', 'original_transaction_id')
    op.add_column('billing_transaction', sa.Column('original_transaction_id', postgresql.UUID(), nullable=True))

    op.alter_column('billing_transaction', 'company_id', existing_type=sa.INTEGER(), nullable=False)
    op.alter_column('billing_transaction', 'person_id', existing_type=sa.INTEGER(), nullable=False)
    op.alter_column(
        'billing_transaction',
        'status',
        existing_type=postgresql.ENUM('reserved', 'paid', 'ready_to_send', 'completed', name='transactionstatus'),
        nullable=False,
    )
    op.alter_column(
        'billing_transaction',
        'type',
        existing_type=postgresql.ENUM('penalty', 'refund', 'purchase', name='transactiontype'),
        nullable=False,
    )
    op.alter_column('billing_transaction', 'price', existing_type=sa.NUMERIC(), nullable=False)
    op.alter_column('billing_transaction', 'provider_fee', existing_type=sa.NUMERIC(), nullable=False)
    op.alter_column('billing_transaction', 'yandex_fee', existing_type=sa.NUMERIC(), nullable=False)
    op.alter_column(
        'billing_transaction',
        'currency',
        existing_type=postgresql.ENUM('other', 'uah', 'rub', 'usd', 'eur', name='currencytype'),
        nullable=False,
    )
    op.alter_column(
        'billing_transaction',
        'is_obsolete',
        existing_type=sa.BOOLEAN(),
        nullable=False,
    )
    op.create_foreign_key(
        op.f('fk__billing_transaction__trip_id__trip'),
        'billing_transaction',
        'trip',
        ['trip_id'],
        ['trip_id'],
    )


def downgrade():
    op.drop_constraint(op.f('fk__billing_transaction__trip_id__trip'), 'billing_transaction', type_='foreignkey')
    op.alter_column('billing_transaction', 'is_obsolete', existing_type=sa.BOOLEAN(), nullable=True)
    op.alter_column(
        'billing_transaction',
        'currency',
        existing_type=postgresql.ENUM('other', 'uah', 'rub', 'usd', 'eur', name='currencytype'),
        nullable=True,
    )
    op.alter_column(
        'billing_transaction',
        'yandex_fee',
        existing_type=sa.NUMERIC(),
        nullable=True,
    )
    op.alter_column(
        'billing_transaction',
        'provider_fee',
        existing_type=sa.NUMERIC(),
        nullable=True,
    )
    op.alter_column('billing_transaction', 'price', existing_type=sa.NUMERIC(), nullable=True)
    op.alter_column(
        'billing_transaction',
        'type',
        existing_type=postgresql.ENUM('penalty', 'refund', 'purchase', name='transactiontype'),
        nullable=True,
    )
    op.alter_column(
        'billing_transaction',
        'status',
        existing_type=postgresql.ENUM('reserved', 'paid', 'ready_to_send', 'completed', name='transactionstatus'),
        nullable=True,
    )
    op.alter_column('billing_transaction', 'person_id', existing_type=sa.INTEGER(), nullable=True)
    op.alter_column('billing_transaction', 'company_id', existing_type=sa.INTEGER(), nullable=True)

    op.drop_column('billing_transaction', 'trip_id')

    op.drop_column('billing_transaction', 'transaction_id')
    op.drop_column('billing_transaction', 'original_transaction_id')

    op.add_column('billing_transaction',  sa.Column('transaction_id', sa.BigInteger(), nullable=True))
    op.add_column('billing_transaction',  sa.Column('original_transaction_id', sa.BigInteger(), nullable=True))
