"""create registry meta table

Revision ID: 0030
Revises: 0029
Create Date: 2022-07-04 11:26:07.109421+00:00

"""
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = '0030'
down_revision = '0029'
branch_labels = None
depends_on = None


registry_status_type = sa.Enum(
    'created',
    'ready',
    'send',
    name='registrystatus',
)


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('registry_meta',
        sa.Column('registry_id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('s3_key', sa.String(length=512), nullable=False),
        sa.Column('filename', sa.String(length=256), nullable=True),
        sa.Column('size', sa.Integer(), nullable=True),
        sa.Column('status', registry_status_type, nullable=False),
        sa.PrimaryKeyConstraint('registry_id', name=op.f('pk__registry_meta')),
        sa.UniqueConstraint('s3_key', name=op.f('uq__registry_meta__s3_key'))
    )
    op.create_index('registry_meta__s3_key', 'registry_meta', ['s3_key'], unique=False)
    op.create_index('registry_meta__status_date', 'registry_meta', ['created_at', 'status'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('registry_meta__status_date', table_name='registry_meta')
    op.drop_index('registry_meta__s3_key', table_name='registry_meta')
    op.drop_table('registry_meta')
    registry_status_type.drop(op.get_bind(), checkfirst=False)
    # ### end Alembic commands ###
