"""Add deposit table and transaction service type

Revision ID: 0032
Revises: 0031
Create Date: 2022-07-13 15:31:07.435754+00:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

from intranet.trip.alembic.utils import upgrade_enum


# revision identifiers, used by Alembic.
revision = '0032'
down_revision = '0031'
branch_labels = None
depends_on = None


def upgrade():
    op.create_table(
        'billing_deposit',
        sa.Column('deposit_id', postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('charge_date', sa.Date(), nullable=False),
        sa.Column('company_id', sa.Integer(), nullable=False),
        sa.Column('amount', sa.DECIMAL(), nullable=False),
        sa.Column('author_id', sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ['author_id'],
            ['person.person_id'],
            name=op.f('fk__deposit__author_id__person'),
        ),
        sa.ForeignKeyConstraint(
            ['company_id'],
            ['list_company.company_id'],
            name=op.f('fk__deposit__company_id__list_company'),
        ),
        sa.PrimaryKeyConstraint('deposit_id', name=op.f('pk__deposit')),
    )

    transaction_service_type = postgresql.ENUM(
        'avia',
        'hotel',
        'rail',
        'transfer',
        'vip_lounge',
        'fast_track',
        'additional',
        'aeroexpress',
        'insurance',
        name='transactionservicetype',
    )
    upgrade_enum(
        name='transactiontype',
        values=['refund', 'purchase', 'exchange'],
        columns=[
            ('billing_transaction', 'type'),
        ],
    )
    upgrade_enum(
        name='transactionstatus',
        values=['paid', 'verified', 'completed'],
        columns=[
            ('billing_transaction', 'status'),
        ],
    )
    transaction_service_type.create(op.get_bind())
    op.alter_column(
        'billing_transaction',
        'service_type',
        type_=transaction_service_type,
        postgresql_using='service_type::text::transactionservicetype',
    )


def downgrade():
    op.alter_column(
        'billing_transaction',
        'service_type',
        type_=postgresql.ENUM(
            'avia',
            'hotel',
            'rail',
            name='servicetype',
            create_type=False,
        ),
        postgresql_using='service_type::text::servicetype',
    )
    upgrade_enum(
        name='transactiontype',
        values=['refund', 'purchase', 'penalty'],
        columns=[
            ('billing_transaction', 'type'),
        ],
    )
    upgrade_enum(
        name='transactionstatus',
        values=['reserved', 'paid', 'ready_to_send', 'completed'],
        columns=[
            ('billing_transaction', 'status'),
        ],
    )
    op.execute('DROP TYPE transactionservicetype')
    op.drop_table('billing_deposit')
