"""upgrade_universal_service

Revision ID: 0033
Revises: 0032
Create Date: 2022-07-18 19:35:16.914362+00:00

"""
from alembic import op


revision = '0033'
down_revision = '0032'
branch_labels = None
depends_on = None


def upgrade():
    op.drop_index('ext_person_table__aeroclub_profile_id', table_name='ext_person')
    op.alter_column('ext_person', 'aeroclub_profile_id', new_column_name='provider_profile_id')
    op.create_index('ext_person_table__provider_profile_id', 'ext_person', ['provider_profile_id'], unique=False)

    op.drop_index('person_table__aeroclub_profile_id', table_name='person')
    op.alter_column('person', 'aeroclub_profile_id', new_column_name='provider_profile_id')
    op.create_index('person_table__provider_profile_id', 'person', ['provider_profile_id'], unique=False)

    op.alter_column('service', 'aeroclub_service_id', new_column_name='provider_service_id')
    op.alter_column('service', 'aeroclub_order_id', new_column_name='provider_order_id')
    op.alter_column('service', 'aeroclub_document_id', new_column_name='provider_document_id')
    op.alter_column('service', 'is_from_aeroclub', new_column_name='is_from_provider')


def downgrade():
    op.drop_index('ext_person_table__provider_profile_id', table_name='ext_person')
    op.alter_column('ext_person', 'provider_profile_id', new_column_name='aeroclub_profile_id')
    op.create_index('ext_person_table__aeroclub_profile_id', 'ext_person', ['aeroclub_profile_id'], unique=False)

    op.drop_index('person_table__provider_profile_id', table_name='person')
    op.alter_column('person', 'provider_profile_id', new_column_name='aeroclub_profile_id')
    op.create_index('person_table__aeroclub_profile_id', 'person', ['aeroclub_profile_id'], unique=False)

    op.alter_column('service', 'provider_service_id', new_column_name='aeroclub_service_id')
    op.alter_column('service', 'provider_order_id', new_column_name='aeroclub_order_id')
    op.alter_column('service', 'provider_document_id', new_column_name='aeroclub_document_id')
    op.alter_column('service', 'is_from_provider', new_column_name='is_from_aeroclub')
