"""add external_document_id

Revision ID: 0032
Revises: 0029
Create Date: 2022-06-30 22:18:15.255212+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0034'
down_revision = '0033'
branch_labels = None
depends_on = None


def upgrade():
    op.add_column('person_trip', sa.Column('provider_city_from_id', sa.String(length=1024), nullable=True))
    op.add_column('trip', sa.Column('provider_city_from_id', sa.String(length=1024), nullable=True))
    op.add_column('trip', sa.Column('provider_city_to_id', sa.String(length=1024), nullable=True))
    op.add_column('trip_route_point', sa.Column('provider_city_id', sa.String(length=1024), nullable=True))
    op.add_column('person_trip_route_point', sa.Column('provider_city_id', sa.String(length=1024), nullable=True))
    op.create_index('person_trip__provider_city_from_id', 'person_trip',
                    ['provider_city_from_id'], unique=False)


def downgrade():
    op.drop_column('person_trip', 'provider_city_from_id')
    op.drop_column('trip', 'provider_city_from_id')
    op.drop_column('trip', 'provider_city_to_id')
    op.drop_column('trip_route_point', 'provider_city_id')
    op.drop_column('person_trip_route_point', 'provider_city_id')
