"""add_support_to_person

Revision ID: 0036
Revises: 0035
Create Date: 2022-07-20 18:22:12.461548+00:00

"""
from alembic import op
import sqlalchemy as sa

revision = '0036'
down_revision = '0035'
branch_labels = None
depends_on = None


def upgrade():
    op.add_column('person', sa.Column('support_id', sa.Integer(), nullable=True))
    op.add_column('person', sa.Column('chat_id', sa.String(length=64), nullable=True))
    op.create_foreign_key(op.f('fk__person__support_id__person'), 'person', 'person', ['support_id'], ['person_id'])


def downgrade():
    op.drop_constraint(op.f('fk__person__support_id__person'), 'person', type_='foreignkey')
    op.drop_column('person', 'chat_id')
    op.drop_column('person', 'support_id')
