"""add external_document_id

Revision ID: 0033
Revises: 0032
Create Date: 2022-06-30 22:18:15.255212+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0039'
down_revision = '0038'
branch_labels = None
depends_on = None


def upgrade():
    op.execute('''
        UPDATE person_trip
        SET provider_city_from_id = aeroclub_city_from_id::text
        WHERE aeroclub_city_from_id IS NOT NULL AND provider_city_from_id IS NULL
    ''')
    op.execute('''
        UPDATE trip
        SET provider_city_from_id = aeroclub_city_from_id::text
        WHERE aeroclub_city_from_id IS NOT NULL AND provider_city_from_id IS NULL
    ''')
    op.execute('''
        UPDATE trip
        SET provider_city_to_id = aeroclub_city_to_id::text
        WHERE aeroclub_city_to_id IS NOT NULL AND provider_city_to_id IS NULL
    ''')
    op.execute('''
        UPDATE trip_route_point
        SET provider_city_id = aeroclub_city_id::text
        WHERE aeroclub_city_id IS NOT NULL AND provider_city_id IS NULL
    ''')
    op.execute('''
        UPDATE person_trip_route_point
        SET provider_city_id = aeroclub_city_id::text
        WHERE aeroclub_city_id IS NOT NULL AND provider_city_id IS NULL
    ''')


def downgrade():
    op.execute('''
        UPDATE person_trip
        SET aeroclub_city_from_id::text = provider_city_from_id::integer
        WHERE aeroclub_city_from_id IS NULL AND provider_city_from_id IS NOT NULL
    ''')
    op.execute('''
        UPDATE trip
        SET aeroclub_city_from_id::text = provider_city_from_id::integer
        WHERE aeroclub_city_from_id IS NULL AND provider_city_from_id IS NOT NULL
    ''')
    op.execute('''
        UPDATE trip
        SET aeroclub_city_to_id::text = provider_city_to_id::integer
        WHERE aeroclub_city_to_id IS NULL AND provider_city_to_id IS NOT NULL
    ''')
    op.execute('''
        UPDATE trip_route_point
        SET aeroclub_city_id::text = provider_city_id::integer
        WHERE aeroclub_city_id IS NULL AND provider_city_id IS NOT NULL
    ''')
    op.execute('''
        UPDATE person_trip_route_point
        SET aeroclub_city_id::text = provider_city_id::integer
        WHERE aeroclub_city_id IS NULL AND provider_city_id IS NOT NULL
    ''')
