from fastapi import Request

from intranet.trip.ext_api.src.api.auth import get_tvm_service_ticket
from intranet.trip.ext_api.src.config import settings
from intranet.trip.ext_api.src.lib.trip.api import TripClient
from intranet.trip.ext_api.src.exceptions import PermissionDenied


async def get_trip_client():
    yield TripClient(
        host=settings.trip_url,
        service_ticket=await get_tvm_service_ticket('trip'),
    )


def only_for_provider(provider: str):

    async def dependency(request: Request):
        if settings.ENV_TYPE == 'development':
            return

        user_uid = request.state.user_uid
        if not user_uid or user_uid != settings.UID_PROVIDERS[provider]:
            raise PermissionDenied()

    return dependency
