import logging

from fastapi import APIRouter, Depends, Response

from intranet.trip.ext_api.src.api.depends import (
    get_trip_client,
    only_for_provider,
)
from intranet.trip.ext_api.src.api.schemas import Notification, Event
from intranet.trip.ext_api.src.lib.trip.api import TripClient
from intranet.trip.ext_api.src.logic.trip import notification_action


logger = logging.getLogger(__name__)
router = APIRouter()


@router.post('/messages/notify', status_code=201, response_class=Response)
async def notify(
    notification: Notification,
    _auth=Depends(only_for_provider('aeroclub')),
    trip: TripClient = Depends(get_trip_client),
):
    trip_id = notification.data.businessTripNumber
    journey_id = notification.data.journeyNumber
    logger.info(
        'notify about new messages for aeroclub_journey_id=%d, aeroclub_trip_id=%d',
        journey_id,
        trip_id
    )
    await notification_action(
        trip.notification_sync,
        aeroclub_journey_id=journey_id,
        aeroclub_trip_id=trip_id,
    )


@router.post('/events', status_code=201, response_class=Response)
async def events(
    event: Event,
    _auth=Depends(only_for_provider('aeroclub')),
    trip: TripClient = Depends(get_trip_client),
):
    logger.info(
        'event %s from aeroclub aeroclub_journey_id=%d, aeroclub_trip_id=%d',
        event.EventCode,
        event.Trip.JourneyNumber,
        event.Trip.BusinessTripNumber,
    )
    await notification_action(trip.handle_event, event=event)
