from pydantic import BaseModel


class AeroclubTripIds(BaseModel):
    businessTripNumber: int
    journeyNumber: int
    postId: int = None


class Notification(BaseModel):
    data: AeroclubTripIds
    type: str


class EventTrip(BaseModel):
    JourneyNumber: int
    BusinessTripNumber: int


class EventService(BaseModel):
    OrderNumber: int
    ServiceNumber: int


class Event(BaseModel):
    EventCode: str
    Trip: EventTrip
    Services: list[EventService] = None

    def as_trip_json(self):
        return {
            'code': self.EventCode,
            'aeroclub_journey_id': self.Trip.JourneyNumber,
            'aeroclub_trip_id': self.Trip.BusinessTripNumber,
            'services': [{
                'provider_order_id': service.OrderNumber,
                'provider_service_id': service.ServiceNumber,
                'aeroclub_order_id': service.OrderNumber,
                'aeroclub_service_id': service.ServiceNumber,
            } for service in self.Services] if self.Services else None,
        }
