from pydantic import BaseSettings


class Settings(BaseSettings):
    ENV_TYPE: str = 'default'
    DEBUG: bool = True

    TVM_CLIENT_ID: int = 2020751
    TVM_SERVICES: dict = {
        'trip': TVM_CLIENT_ID,
        'passport': 239,
    }

    TRIP_HOST: str = 'trip.test.yandex-team.ru'

    ENABLE_B2B: bool = False

    BLACKBOX_URL: str = 'http://blackbox-mimino.yandex.net/blackbox'

    # Паспортный uid пользователя от которого ходит аэроклуб
    AEROCLUB_UID: str = '1268090415'

    # Паспортный uid пользователя от которого ходит авиацентр
    AVIACENTER_UID: str = '111'

    UID_PROVIDERS = {
        'aeroclub': AEROCLUB_UID,
        'aviacenter': AVIACENTER_UID,
    }

    @property
    def trip_url(self):
        return f'https://{self.TRIP_HOST}'
