from async_clients.clients.base import BaseClient
from async_clients.auth_types import TVM2
import aiohttp
import logging
from tenacity import TryAgain

from intranet.trip.ext_api.src.lib.trip.exceptions import TripError


logger = logging.getLogger(__name__)


class TripClient(BaseClient):

    AUTH_TYPES = {TVM2}

    async def parse_response(self, response: aiohttp.ClientResponse, **kwargs) -> dict:
        if response.status in self.RETRY_CODES:
            raise TryAgain()
        if response.status >= 400:
            message = (
                f'Got status: {response.status}, for request: '
                f'{response.method} {response.url}'
            )
            logger.info(message)
            content = await response.json()
            raise TripError(status_code=response.status, content=content)

        return await getattr(response, self.RESPONSE_TYPE)()

    async def notification_sync(
        self,
        aeroclub_journey_id: int,
        aeroclub_trip_id: int,
        is_b2b: bool = False,
    ) -> dict:
        json = {
            'aeroclub_journey_id': aeroclub_journey_id,
            'aeroclub_trip_id': aeroclub_trip_id,
        }
        namespace = 'external' if is_b2b else 'api'
        path = f'/{namespace}/notifications/sync'

        return await self._make_request(
            method='put',
            path=path,
            json=json,
        )

    async def handle_event(self, event, is_b2b: bool = False):
        namespace = 'external' if is_b2b else 'api'
        path = f'/{namespace}/notifications/event'

        return await self._make_request(
            method='post',
            path=path,
            json=event.as_trip_json(),
        )
