import sys

from intranet.trip.ext_api.src.config import settings


LOG_FORMAT = 'json' if settings.ENV_TYPE != 'development' else 'default'
ENV_LOG_LEVEL = 'DEBUG' if settings.DEBUG else 'INFO'
LOGGING_CONFIG = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'default': {
            '()': 'ylog.context.ContextFormatter',
            'datefmt': '%Y-%m-%d %H:%M:%S',
            'format': '[%(asctime)s][%(name)s] - %(levelname)s - %(message)s',
        },
        'json': {
            '()': 'ylog.format.QloudJsonFormatter',
        },
    },
    'handlers': {
        'stream': {
            'class': 'logging.StreamHandler',
            'formatter': LOG_FORMAT,
            'stream': sys.stdout,
            'level': ENV_LOG_LEVEL,
        },
    },
    'loggers': {
        'tvm2.aio.base': {
            'handlers': ['stream'],
            'level': ENV_LOG_LEVEL,
            'propagate': False,
        },
        'intranet.trip.ext_api.src': {
            'handlers': ['stream'],
            'propagate': False,
            'level': ENV_LOG_LEVEL,
        },
        'ya.test': {'level': 'WARNING'},
        'httpx.client': {'level': 'WARNING'},
        'kikimr.public.sdk.python.persqueue._core': {'level': 'WARNING'},
        'ydb.connection': {'level': 'WARNING'},
        'ydb.pool.Discovery': {'level': 'WARNING'},
    },
    'root': {
        'handlers': ['stream'],
        'level': ENV_LOG_LEVEL,
    },
}
