PY3_LIBRARY()

OWNER(g:tools-trip)

PEERDIR(
    contrib/python/aiohttp
    contrib/python/fastapi
    contrib/python/hypercorn
    contrib/python/ipython
    contrib/python/pydantic

    library/python/async_clients
    library/python/deprecated/ticket_parser2
    library/python/tvm2
)

PY_SRCS(
    api/__init__.py
    api/depends.py

    api/auth/__init__.py
    api/auth/tvm.py

    api/endpoints/__init__.py
    api/endpoints/aeroclub.py
    api/endpoints/webhooks.py

    api/schemas/__init__.py
    api/schemas/aeroclub.py

    config/__init__.py
    config/default.py
    config/development.py
    config/testing.py
    config/production.py

    lib/trip/__init__.py
    lib/trip/api.py
    lib/trip/exceptions.py

    logic/trip.py

    exceptions.py
    logging.py
    main.py
    middlewares.py
    router.py
)
END()
