from pydantic import BaseSettings


class ArqSettings(BaseSettings):
    ARQ_MAX_JOB_TRIES: int = 4
    ARQ_MAX_CONCURRENT_JOBS: int = 10  # maximum number of jobs to run at a time in one worker
    ARQ_POLL_DELAY: float = 0.5  # duration between polling the queue for new jobs
    ARQ_KEEP_RESULT_PERIOD: int = 3600  # default duration to keep job results for


arq_settings = ArqSettings()


class WorkerSettingsBase:
    max_tries = arq_settings.ARQ_MAX_JOB_TRIES
    max_jobs = arq_settings.ARQ_MAX_CONCURRENT_JOBS
    poll_delay = arq_settings.ARQ_POLL_DELAY
    keep_result_period = arq_settings.ARQ_KEEP_RESULT_PERIOD
