import logging
import time
from typing import Any, Optional

from async_clients.clients.base import BaseClient
from ylog.context import log_context


class BaseProfilingClient(BaseClient):

    CLIENT_NAME = None

    async def _make_request(
        self,
        path: str,
        method: str = 'get',
        params: Optional[dict] = None,
        json: Optional[dict] = None,
        data: Optional[Any] = None,
        headers: Optional[dict] = None,
        timeout: int = None,
        **kwargs,
    ):
        start_time = time.time()
        result = await super()._make_request(
            path,
            method,
            params,
            json,
            data,
            headers,
            timeout,
            **kwargs,
        )
        execution_time = time.time() - start_time
        context_data = {
            'client': self.CLIENT_NAME,
            'host': self.host,
            'path': path,
            'method': method.upper(),
            'execution_time': execution_time * 1000,
        }
        with log_context(upstream=context_data):
            logging.info(
                'profiling of %s request %s: %s - took %.3f ms',
                self.CLIENT_NAME,
                method.upper(),
                path,
                execution_time * 1000,
            )
        return result
