import logging
from typing import Optional

from tvm2 import TVM2
from tvmauth import BlackboxTvmId as BlackboxClientId

from intranet.trip.src.config import settings

logger = logging.getLogger(__name__)


def get_tvm_client():
    return TVM2(
        client_id=settings.TVM_CLIENT_ID,
        blackbox_client=BlackboxClientId.Prod,
        allowed_clients=settings.allowed_clients,
    )


async def get_tvm_service_ticket(destination: str) -> Optional[str]:
    destination = settings.tvm_services.get(destination)
    if not destination:
        return
    return await get_tvm_client().get_service_ticket(destination=str(destination))
