from pydantic import BaseSettings


class Settings(BaseSettings):
    ENV_TYPE: str = 'default'
    DEBUG: bool = True

    DEPLOY_STAGE_ID: str = 'stage'
    DEPLOY_UNIT_ID: str = 'unit'

    TRIP_ROBOT_LOGIN = 'robot-trip'

    REDIS_HOST: str = 'localhost'
    REDIS_PORT: int = 6379
    REDIS_PASSWORD: str = 'trip'
    REDIS_SENTINEL_MASTER: str = 'trip-test-redis'

    @property
    def REDIS_QUEUE_NAME(self):
        return f'arq:{self.DEPLOY_STAGE_ID}_{self.DEPLOY_UNIT_ID}_queue'

    TVM_CLIENT_ID: int = 2020751
    TVM2_ASYNC: bool = True
    TVM2_USE_DAEMON: bool = True

    @property
    def tvm_services(self):
        return {
            'trip': self.TVM_CLIENT_ID,
        }

    @property
    def allowed_clients(self):
        return []

    TRIP_HOST: str = 'trip.test.yandex-team.ru'

    @property
    def trip_url(self):
        return f'https://{self.TRIP_HOST}'

    ENABLE_ERROR_BOOSTER: bool = False
