from typing import Optional

from fastapi import Request


def get_oauth_token(request: Request) -> Optional[str]:
    """Example
    Authorization: OAuth vF9dft4qmT
    """
    headers = request.headers

    try:
        name, token = headers.get('Authorization', '').split(' ')
        if name.lower() == 'oauth':
            return token
    except ValueError:
        pass
    return None
