import logging
from typing import Optional

from tvm2 import TVM2
from tvmauth import BlackboxTvmId as BlackboxClientId

from intranet.trip.src.config import settings

logger = logging.getLogger(__name__)


SERVICE_TICKET_HEADER = 'X-Ya-Service-Ticket'
USER_TICKET_HEADER = 'X-Ya-User-Ticket'


def get_tvm_client():
    return TVM2(
        client_id=settings.TVM_CLIENT_ID,
        blackbox_client=BlackboxClientId.Prod,
        allowed_clients=settings.allowed_clients,
    )


async def get_tvm_service_ticket(destination: str) -> Optional[str]:
    destination = settings.tvm_services.get(destination)
    if not destination:
        return
    return await get_tvm_client().get_service_ticket(destination=str(destination))


async def get_tvm_service_ticket_header(destination: str) -> dict[str, str]:
    service_ticket = await get_tvm_service_ticket(destination)
    return {
        SERVICE_TICKET_HEADER: service_ticket,
    }
