from intranet.trip.src.models import Service
from intranet.trip.src.api.schemas.service import (
    AviaService, RailService, HotelService,
    AviaLeg,
    AviaSegment,
)
from intranet.trip.src.api.converters.base import BaseServiceConverter


class AeroclubServiceConverter(BaseServiceConverter):

    def _get_avia_segment(self, ac_segment: dict) -> AviaSegment:
        return AviaSegment(
            flight_number=ac_segment['flight_number'],
            airline=ac_segment['airline'],
            aircraft=ac_segment.get('aircraft'),
            baggage=ac_segment['baggage'],
            # class_of_service
            # departure_from
            # arrival_to
            departure_at=ac_segment['departure_at'],
            arrival_at=ac_segment['arrival_at'],
            duration=ac_segment['duration'],
            fire_bases=ac_segment.get('fare_bases'),
            fire_family=ac_segment.get('fare_family'),
        )

    def _get_avia_leg(self, ac_leg) -> AviaLeg:
        return AviaLeg(
            departure_from=ac_leg['departure_from'],
            arrival_to=ac_leg['arrival_to'],
            departure_at=ac_leg['departure_at'],
            departure_at_utc=ac_leg['departure_at_utc'],
            arrival_at=ac_leg['arrival_at'],
            arrival_at_utc=ac_leg['arrival_at_utc'],
            # cabin_class=
            transfers=ac_leg['transfers'],
            duration=ac_leg['duration'],
            segments=[self._get_avia_segment(ac_segment) for ac_segment in ac_leg['segments']],
        )

    def convert_avia(self, service: Service, provider_data: dict) -> AviaService:
        db_fields = service.dict()

        return AviaService(
            legs=[self._get_avia_leg(ac_leg) for ac_leg in provider_data['avia_leg']],

            analytics=provider_data['analytics'],
            documents=provider_data['documents'],
            tariff_total=provider_data['tariff_total'],
            **db_fields
        )

    def convert_rail(self, service: Service, provider_data: dict) -> RailService:
        db_fields = service.dict()

        return RailService(
            departure_at=provider_data['departure_at'],
            # departure_from=
            arrival_at=provider_data['arrival_at'],
            duration=provider_data['duration'],
            carriage=provider_data['carriage'],
            rail_info=provider_data['train'],

            analytics=provider_data['analytics'],
            documents=provider_data['documents'],
            tariff_total=provider_data['tariff_total'],
            **db_fields
        )

    def convert_hotel(self, service: Service, provider_data: dict) -> HotelService:
        db_fields = service.dict()

        return HotelService(
            address=provider_data['address'],
            name=provider_data['name'],
            stars=provider_data['stars'],
            start_at=provider_data['start_at'],
            start_at_utc=provider_data['start_at_utc'],
            end_at=provider_data['end_at'],
            end_at_utc=provider_data['end_at_utc'],

            analytics=provider_data['analytics'],
            documents=provider_data['documents'],
            tariff_total=provider_data['tariff_total'],
            **db_fields
        )
