from intranet.trip.src.models import Service
from intranet.trip.src.api.schemas.service import AviaService, RailService, HotelService
from intranet.trip.src.enums import ServiceType


class BaseServiceConverter:
    """
    Базовый конвертер для преобразования услуг поставщика в униврсальный формат
    """
    def convert(self, service: Service, ac_service: dict):
        if service.type == ServiceType.avia:
            return self.convert_avia(service, ac_service)
        if service.type == ServiceType.rail:
            return self.convert_rail(service, ac_service)
        if service.type == ServiceType.hotel:
            return self.convert_hotel(service, ac_service)

    def convert_avia(self, service: Service, provider_data: dict) -> AviaService:
        raise NotImplementedError

    def convert_rail(self, service: Service, provider_data: dict) -> RailService:
        raise NotImplementedError

    def convert_hotel(self, service: Service, provider_data: dict) -> HotelService:
        raise NotImplementedError
